<?php

add_action('wp_enqueue_scripts', 'add_theme_scripts');
function add_theme_scripts() {
    // WordPress will handle title tag
    // Tailwind CSS is loaded via CDN in header.php
    // Chart.js will be loaded conditionally in page.php if needed
}

add_action('after_setup_theme', 'pishro_setup_theme');
function pishro_setup_theme() {
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');

    register_nav_menus(array(
        'main-menu' => __('منوی اصلی', 'pishro'),
    ));
}

add_action('widgets_init', 'pishro_sidebar');
function pishro_sidebar() {
    $args = array(
        'before_widget' => '<div class="f-w-contet">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    );

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 1', 'pishro'),
        'id'   => 'pishro_footer_one',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 2', 'pishro'),
        'id'   => 'pishro_footer_two',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 3', 'pishro'),
        'id'   => 'pishro_footer_three',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 4', 'pishro'),
        'id'   => 'pishro_footer_four',
    )));
}