    <!-- Footer -->
    <footer class="bg-slate-900/70 border-t border-slate-800 py-12">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-8 mb-8">
                <div>
                    <div class="flex items-center gap-2 mb-4">
                        <div class="w-8 h-8 bg-gradient-to-br from-emerald-500 to-blue-500 rounded-lg flex items-center justify-center font-bold text-white text-sm">PS</div>
                        <span class="font-bold text-lg text-white"><?php bloginfo('name'); ?></span>
                    </div>
                    <p class="text-slate-400 text-sm">
                        <?php bloginfo('description'); ?>
                    </p>
                </div>
                
                <div>
                    <h4 class="font-bold text-white mb-4">لینک‌های سریع</h4>
                    <ul class="space-y-2 text-sm text-slate-400">
                        <li><a href="<?php echo esc_url(home_url('/')); ?>" class="hover:text-emerald-400 transition">خانه</a></li>
                        <?php
                        // Get pages for footer
                        $footer_pages = get_pages(array(
                            'sort_column' => 'menu_order',
                            'number' => 5
                        ));
                        foreach ($footer_pages as $page) {
                            echo '<li><a href="' . esc_url(get_permalink($page->ID)) . '" class="hover:text-emerald-400 transition">' . esc_html($page->post_title) . '</a></li>';
                        }
                        ?>
                    </ul>
                </div>
                
                <div>
                    <h4 class="font-bold text-white mb-4">خدمات</h4>
                    <ul class="space-y-2 text-sm text-slate-400">
                        <?php
                        // Get pages with specific templates
                        $service_pages = get_pages(array(
                            'meta_key' => '_wp_page_template',
                            'meta_value' => array('page-visitors.php', 'page-customers.php', 'page-bot-owners.php'),
                            'sort_column' => 'menu_order'
                        ));
                        foreach ($service_pages as $page) {
                            echo '<li><a href="' . esc_url(get_permalink($page->ID)) . '" class="hover:text-emerald-400 transition">' . esc_html($page->post_title) . '</a></li>';
                        }
                        ?>
                    </ul>
                </div>
                
                <div>
                    <h4 class="font-bold text-white mb-4">تماس با ما</h4>
                    <ul class="space-y-2 text-sm text-slate-400">
                        <li>پشتیبانی: ۲۴/۷</li>
                        <li>ایمیل: support@programingservices.ir</li>
                        <li>تلگرام: @programingservices</li>
                    </ul>
                </div>
            </div>
            
            <div class="border-t border-slate-800 pt-8 text-center text-sm text-slate-500">
                <p>© <?php echo date('Y'); ?> <?php bloginfo('name'); ?>. تمامی حقوق محفوظ است.</p>
                <p class="mt-2">طراحی شده با ❤️ برای جامعه توسعه‌دهندگان ایرانی</p>
            </div>
        </div>
    </footer>

<?php wp_footer(); ?>
</body>
</html>
