<!doctype html>
<html <?php language_attributes(); ?> dir="rtl" lang="fa">
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head(); ?>

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Vazirmatn:wght@100;300;400;700;900&display=swap" rel="stylesheet">

    <?php if ( ! function_exists('is_woocommerce') || ! ( is_woocommerce() || is_cart() || is_checkout() || is_account_page() ) ) : ?>


    <!-- Tailwind -->
    <script>
        tailwind.config = {
            corePlugins: { preflight: false },
            theme: {
                extend: {
                    fontFamily: { sans: ['Vazirmatn', 'sans-serif'] },
                    colors: {
                        slate: {
                            200: '#e2e8f0', 300: '#cbd5e1', 400: '#94a3b8',
                            500: '#64748b', 700: '#334155', 800: '#1e293b',
                            850: '#1e293b', 900: '#0f172a', 950: '#020617',
                        },
                        emerald: { 400: '#34d399', 450: '#10b981', 500: '#10b981', 550: '#059669', 600: '#047857' }
                    }
                }
            }
        }
    </script>
    <script src="https://cdn.tailwindcss.com"></script>
    <?php endif; ?>

    <style>
        body {
            font-family: 'Vazirmatn', sans-serif;
            background-color: #0f172a; /* Slate-900 */
            color: #e2e8f0; /* Slate-200 */
            scroll-behavior: smooth;
        }

        .gradient-text {
            background: linear-gradient(to left, #34d399, #60a5fa);
            -webkit-background-clip: text;
            background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .glow-effect {
            box-shadow: 0 0 20px rgba(16, 185, 129, 0.15);
        }

        /* WordPress Menu Styles */
        .wp-menu ul {
            list-style: none;
            margin: 0;
            padding: 0;
            display: flex;
            gap: 1.5rem;
        }
        .wp-menu li { display: inline-block; margin: 0; }
        .wp-menu a {
            text-decoration: none;
            color: #94a3b8;
            transition: color 0.2s;
            font-size: 0.875rem;
        }
        .wp-menu a:hover { color: #10b981; }
        .wp-menu .current-menu-item > a,
        .wp-menu .current-page-item > a { color: #10b981; }

        .wp-menu-mobile ul { list-style: none; margin: 0; padding: 0; }
        .wp-menu-mobile li { margin: 0; }
        .wp-menu-mobile a {
            text-decoration: none;
            color: #94a3b8;
            transition: all 0.2s;
            display: block;
            padding: 0.5rem 1rem;
            border-radius: 0.5rem;
        }
        .wp-menu-mobile a:hover {
            color: #10b981;
            background-color: #1e293b;
        }
        .wp-menu-mobile .current-menu-item > a,
        .wp-menu-mobile .current-page-item > a { color: #10b981; }

    </style>
</head>
<body <?php body_class('antialiased selection:bg-emerald-500 selection:text-white'); ?>>
<?php wp_body_open(); ?>

<!-- Navigation -->
<nav class="fixed w-full z-50 bg-slate-900/90 backdrop-blur-md border-b border-slate-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center h-16">
            <div class="flex items-center gap-2">
                <div class="w-8 h-8 bg-gradient-to-br from-emerald-500 to-blue-500 rounded-lg flex items-center justify-center font-bold text-white text-sm">PS</div>
                <a href="<?php echo esc_url(home_url('/')); ?>" class="font-bold text-lg tracking-tight text-white hover:text-emerald-400 transition">
                    <?php bloginfo('name'); ?>
                </a>
            </div>

            <div class="hidden md:flex gap-6 text-sm text-slate-400 wp-menu">
                <?php
                if (has_nav_menu('main-menu')) {
                    wp_nav_menu(array(
                        'theme_location' => 'main-menu',
                        'container' => false,
                        'menu_class' => 'flex gap-6',
                        'fallback_cb' => false,
                    ));
                } else {
                    echo '<a href="' . esc_url(home_url('/')) . '" class="hover:text-emerald-400 transition">خانه</a>';
                    $pages = get_pages(array('sort_column' => 'menu_order', 'number' => 5));
                    foreach ($pages as $page) {
                        echo '<a href="' . esc_url(get_permalink($page->ID)) . '" class="hover:text-emerald-400 transition">' . esc_html($page->post_title) . '</a>';
                    }
                }
                ?>
            </div>

            <div class="flex items-center gap-2">
                <?php
                $cta_pages = get_pages(array(
                    'meta_key' => '_wp_page_template',
                    'meta_value' => 'page-customers.php',
                    'number' => 1
                ));
                if (empty($cta_pages)) {
                    $cta_pages = get_pages(array('number' => 1, 'sort_column' => 'menu_order'));
                }
                if (!empty($cta_pages)) {
                    $cta_page = $cta_pages[0];
                    echo '<a href="' . esc_url(get_permalink($cta_page->ID)) . '" class="hidden sm:block bg-emerald-600 hover:bg-emerald-500 text-white px-4 py-2 rounded-full text-sm font-bold transition shadow-lg shadow-emerald-900/20">' . esc_html($cta_page->post_title) . '</a>';
                }
                ?>

                <button id="mobile-menu-btn" class="md:hidden text-slate-400 hover:text-emerald-400 p-2" aria-label="menu">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                    </svg>
                </button>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden md:hidden bg-slate-900 border-t border-slate-800 py-4 wp-menu-mobile">
            <?php
            if (has_nav_menu('main-menu')) {
                wp_nav_menu(array(
                    'theme_location' => 'main-menu',
                    'container' => false,
                    'menu_class' => 'flex flex-col space-y-3',
                    'fallback_cb' => false,
                ));
            } else {
                echo '<a href="' . esc_url(home_url('/')) . '" class="px-4 py-2 text-slate-400 hover:text-emerald-400 hover:bg-slate-800 rounded-lg transition">خانه</a>';
                $pages = get_pages(array('sort_column' => 'menu_order', 'number' => 5));
                foreach ($pages as $page) {
                    echo '<a href="' . esc_url(get_permalink($page->ID)) . '" class="px-4 py-2 text-slate-400 hover:text-emerald-400 hover:bg-slate-800 rounded-lg transition">' . esc_html($page->post_title) . '</a>';
                }
            }
            ?>
        </div>
    </div>
</nav>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const menuBtn = document.getElementById('mobile-menu-btn');
    const mobileMenu = document.getElementById('mobile-menu');

    if (menuBtn && mobileMenu) {
        menuBtn.addEventListener('click', () => {
            mobileMenu.classList.toggle('hidden');
        });
    }
});
</script>
