<?php

add_action('wp_enqueue_scripts', 'add_theme_scripts');
function add_theme_scripts() {
    // WordPress will handle title tag
    // Tailwind CSS is loaded via CDN in header.php
    // Chart.js will be loaded conditionally in page.php if needed
}

add_action('after_setup_theme', 'pishro_setup_theme');
function pishro_setup_theme() {
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');

    register_nav_menus(array(
        'main-menu' => __('منوی اصلی', 'pishro'),
    ));
}

add_action('widgets_init', 'pishro_sidebar');
function pishro_sidebar() {
    $args = array(
        'before_widget' => '<div class="f-w-contet">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    );

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 1', 'pishro'),
        'id'   => 'pishro_footer_one',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 2', 'pishro'),
        'id'   => 'pishro_footer_two',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 3', 'pishro'),
        'id'   => 'pishro_footer_three',
    )));

    register_sidebar(array_merge($args, array(
        'name' => __('فوتر 4', 'pishro'),
        'id'   => 'pishro_footer_four',
    )));
}

// ✅ Force WooCommerce default styles to load (in case a plugin/theme dequeues them)
add_filter('woocommerce_enqueue_styles', '__return_true');
add_action('wp_enqueue_scripts', function () {
    if (!class_exists('WooCommerce')) {
        return;
    }

    $suffix = is_rtl() ? '-rtl' : '';
    $ver    = defined('WC_VERSION') ? WC_VERSION : null;

    wp_enqueue_style('woocommerce-general', WC()->plugin_url() . "/assets/css/woocommerce{$suffix}.css", [], $ver);
    wp_enqueue_style('woocommerce-layout', WC()->plugin_url() . "/assets/css/woocommerce-layout{$suffix}.css", [], $ver);
    wp_enqueue_style('woocommerce-smallscreen', WC()->plugin_url() . "/assets/css/woocommerce-smallscreen{$suffix}.css", [], $ver, 'only screen and (max-width: 768px)');
}, 999);
