<?php
/**
 * Default Page Template
 * This template is used when no specific page template is selected
 */
get_header(); 

// Check if this is the front page
if (is_front_page()) {
    // Load the home page content from index.php logic
    ?>
    <!-- Hero Section -->
    <header class="pt-32 pb-20 px-4 relative overflow-hidden">
        <!-- Abstract Background Elements -->
        <div class="absolute top-20 right-0 w-96 h-96 bg-emerald-500/10 rounded-full blur-3xl -z-10"></div>
        <div class="absolute bottom-0 left-0 w-96 h-96 bg-blue-500/10 rounded-full blur-3xl -z-10"></div>
        
        <div class="max-w-7xl mx-auto text-center">
            <h1 class="text-4xl md:text-6xl lg:text-7xl font-black mb-6 leading-tight">
                اولین <span class="gradient-text">مارکت‌پلیس SaaS</span> رباتیک
                <br>
                <span class="text-slate-200">برای ربات‌های تلگرام</span>
            </h1>
            
            <p class="text-lg md:text-xl text-slate-400 mb-10 max-w-3xl mx-auto leading-relaxed">
                امنیت سورس کد، کاهش ۹۰٪ هزینه‌ها و درآمد پایدار. پلتفرم ما راه‌حل کامل برای توسعه‌دهندگان و کاربران ربات‌های تلگرام است.
            </p>

            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <?php
                $customers_page = get_page_by_path('customers');
                if ($customers_page) {
                    echo '<a href="' . get_permalink($customers_page->ID) . '" class="px-8 py-4 bg-emerald-600 hover:bg-emerald-500 text-white rounded-xl font-bold transition shadow-xl shadow-emerald-900/20 flex items-center justify-center gap-2 text-lg">شروع استفاده 🚀</a>';
                }
                $visitors_page = get_page_by_path('visitors');
                if ($visitors_page) {
                    echo '<a href="' . get_permalink($visitors_page->ID) . '" class="px-8 py-4 bg-slate-800 hover:bg-slate-700 text-white border border-slate-700 rounded-xl font-bold transition flex items-center justify-center gap-2 text-lg">همکاری در فروش</a>';
                }
                ?>
            </div>
        </div>
    </header>

    <!-- Section 1: Core Value Proposition -->
    <section class="py-20 bg-slate-950 border-y border-slate-800">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-16">
                <span class="text-emerald-400 text-sm font-bold tracking-widest uppercase">چرا ProgrammingServices؟</span>
                <h2 class="text-3xl md:text-4xl font-black mt-4 text-white">انقلاب در مدل کسب‌وکار ربات‌ها</h2>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
                
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 glow-effect">
                    <div class="text-5xl mb-4">🔒</div>
                    <h3 class="text-xl font-bold mb-3 text-white">امنیت مطلق</h3>
                    <p class="text-slate-400 leading-relaxed">
                        سورس کد شما هرگز از سرور خارج نمی‌شود. محافظت کامل در برابر دزدی، هک و پخش غیرقانونی کد.
                    </p>
                </div>

                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 glow-effect">
                    <div class="text-5xl mb-4">💰</div>
                    <h3 class="text-xl font-bold mb-3 text-white">کاهش ۹۰٪ هزینه‌ها</h3>
                    <p class="text-slate-400 leading-relaxed">
                        بدون نیاز به خرید VPS، استخدام برنامه‌نویس یا مدیریت سرور. همه چیز با یک اشتراک ماهانه ساده.
                    </p>
                </div>
                
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 glow-effect">
                    <div class="text-5xl mb-4">📈</div>
                    <h3 class="text-xl font-bold mb-3 text-white">درآمد پایدار</h3>
                    <p class="text-slate-400 leading-relaxed">
                        مدل SaaS به جای فروش یکباره. درآمد ماهانه و تصاعدی برای توسعه‌دهندگان و بازاریابان.
                    </p>
                </div>
            </div>
        </div>
    </section>

    <!-- Section 2: How It Works -->
    <section class="py-20">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-16">
                <span class="text-blue-400 text-sm font-bold tracking-widest uppercase">نحوه کار</span>
                <h2 class="text-3xl md:text-4xl font-black mt-4 text-white">سه قدم ساده تا شروع</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 items-center">
                
                <!-- Step 1 -->
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 text-center relative">
                    <div class="absolute -top-4 -right-4 w-12 h-12 bg-emerald-500 rounded-full flex items-center justify-center text-white font-black text-xl">۱</div>
                    <div class="text-6xl mb-6">👨‍💻</div>
                    <h3 class="text-xl font-bold mb-4 text-white">توسعه‌دهنده</h3>
                    <p class="text-slate-400 leading-relaxed">
                        سورس کد ربات خود را به پلتفرم می‌سپارید. ما آن را روی سرور امن خود می‌زبانی می‌کنیم.
                    </p>
                </div>

                <!-- Arrow -->
                <div class="hidden md:flex justify-center text-slate-600 text-4xl">⬅️</div>
                <div class="md:hidden text-slate-600 text-4xl rotate-90 my-4 text-center">➡️</div>

                <!-- Step 2 -->
                <div class="bg-gradient-to-br from-emerald-900/40 to-slate-900 p-8 rounded-2xl border border-emerald-500/50 text-center relative shadow-xl">
                    <div class="absolute -top-4 -right-4 w-12 h-12 bg-emerald-500 rounded-full flex items-center justify-center text-white font-black text-xl">۲</div>
                    <div class="text-6xl mb-6">☁️</div>
                    <h3 class="text-xl font-bold mb-4 text-emerald-400">پلتفرم ما</h3>
                    <p class="text-slate-300 leading-relaxed">
                        سیستم به صورت خودکار یک نمونه اختصاصی از ربات را برای هر مشتری روی سرور جداگانه فعال می‌کند.
                    </p>
                </div>

                <!-- Arrow -->
                <div class="hidden md:flex justify-center text-slate-600 text-4xl">⬅️</div>
                <div class="md:hidden text-slate-600 text-4xl rotate-90 my-4 text-center">➡️</div>

                <!-- Step 3 -->
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 text-center relative">
                    <div class="absolute -top-4 -right-4 w-12 h-12 bg-emerald-500 rounded-full flex items-center justify-center text-white font-black text-xl">۳</div>
                    <div class="text-6xl mb-6">👤</div>
                    <h3 class="text-xl font-bold mb-4 text-white">مشتری</h3>
                    <p class="text-slate-400 leading-relaxed">
                        مشتری اشتراک ماهانه خریداری می‌کند و از طریق پنل وب، ربات اختصاصی خود را مدیریت می‌کند.
                    </p>
                </div>

            </div>
        </div>
    </section>

    <!-- Section 3: For Different Audiences -->
    <section class="py-20 bg-slate-950 border-y border-slate-800">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-16">
                <span class="text-emerald-400 text-sm font-bold tracking-widest uppercase">خدمات ما</span>
                <h2 class="text-3xl md:text-4xl font-black mt-4 text-white">برای هر کسی راه‌حل داریم</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                
                <!-- Card 1: For Bot Owners -->
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 group">
                    <div class="text-4xl mb-4">🤝</div>
                    <h3 class="text-xl font-bold mb-3 text-white">برای صاحبان ربات</h3>
                    <p class="text-slate-400 mb-6 leading-relaxed">
                        ربات خود را در پلتفرم قرار دهید و از امنیت سورس کد و درآمد پایدار لذت ببرید.
                    </p>
                    <?php
                    $bot_owners_page = get_page_by_path('bot-owners');
                    if ($bot_owners_page) {
                        echo '<a href="' . get_permalink($bot_owners_page->ID) . '" class="inline-block text-emerald-400 font-bold hover:text-emerald-300 transition group-hover:translate-x-1">بیشتر بدانید →</a>';
                    }
                    ?>
                </div>

                <!-- Card 2: For Customers -->
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 group">
                    <div class="text-4xl mb-4">🛒</div>
                    <h3 class="text-xl font-bold mb-3 text-white">برای کاربران</h3>
                    <p class="text-slate-400 mb-6 leading-relaxed">
                        ربات اختصاصی خود را با هزینه کم و بدون دردسر فنی داشته باشید.
                    </p>
                    <?php
                    if ($customers_page) {
                        echo '<a href="' . get_permalink($customers_page->ID) . '" class="inline-block text-emerald-400 font-bold hover:text-emerald-300 transition group-hover:translate-x-1">مشاهده پلن‌ها →</a>';
                    }
                    ?>
                </div>

                <!-- Card 3: For Affiliates -->
                <div class="bg-slate-900 p-8 rounded-2xl border border-slate-800 hover:border-emerald-500/50 transition duration-300 group">
                    <div class="text-4xl mb-4">💼</div>
                    <h3 class="text-xl font-bold mb-3 text-white">برای بازاریابان</h3>
                    <p class="text-slate-400 mb-6 leading-relaxed">
                        ۱۵٪ کمیسیون دائمی از هر فروش. درآمد غیرفعال و تصاعدی بسازید.
                    </p>
                    <?php
                    if ($visitors_page) {
                        echo '<a href="' . get_permalink($visitors_page->ID) . '" class="inline-block text-emerald-400 font-bold hover:text-emerald-300 transition group-hover:translate-x-1">شروع همکاری →</a>';
                    }
                    ?>
                </div>

            </div>
        </div>
    </section>

    <!-- Section 4: Key Features -->
    <section class="py-20">
        <div class="max-w-7xl mx-auto px-4">
            <div class="text-center mb-16">
                <span class="text-blue-400 text-sm font-bold tracking-widest uppercase">ویژگی‌های کلیدی</span>
                <h2 class="text-3xl md:text-4xl font-black mt-4 text-white">چرا ما را انتخاب کنید؟</h2>
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                
                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">⚡️</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">راه‌اندازی فوری</h4>
                        <p class="text-slate-400">فعالسازی ربات در کمتر از ۵ دقیقه. بدون نیاز به دانش فنی.</p>
                    </div>
                </div>

                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">🛡️</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">امنیت بالا</h4>
                        <p class="text-slate-400">سرورهای اختصاصی و ایزوله. محافظت در برابر DDoS و حملات.</p>
                    </div>
                </div>
                
                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">🎛️</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">پنل مدیریت وب</h4>
                        <p class="text-slate-400">مدیریت کامل ربات از طریق پنل کاربری زیبا و ساده.</p>
                    </div>
                </div>
                
                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">♾️</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">بدون محدودیت</h4>
                        <p class="text-slate-400">در پلن‌های بالا، هیچ محدودیتی در حجم و تعداد کاربر نخواهید داشت.</p>
                    </div>
                </div>

                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">📊</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">گزارش‌گیری کامل</h4>
                        <p class="text-slate-400">داشبورد جامع برای نظارت بر عملکرد و آمار ربات.</p>
                    </div>
                </div>
                
                <div class="bg-slate-900 p-6 rounded-xl border border-slate-800 flex items-start gap-4">
                    <div class="text-3xl">🔧</div>
                    <div>
                        <h4 class="text-lg font-bold text-white mb-2">پشتیبانی ۲۴/۷</h4>
                        <p class="text-slate-400">تیم فنی ما همیشه آماده کمک و رفع مشکلات شماست.</p>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <!-- Section 5: CTA -->
    <section class="py-20 bg-slate-950 border-y border-slate-800">
        <div class="max-w-4xl mx-auto px-4 text-center">
            <h2 class="text-3xl md:text-4xl font-black text-white mb-6">
                آماده شروع هستید؟
            </h2>
            <p class="text-lg text-slate-400 mb-10 max-w-2xl mx-auto">
                همین حالا پلن مناسب خود را انتخاب کنید و تجربه استفاده از یک پلتفرم حرفه‌ای را شروع کنید.
            </p>
            <div class="flex flex-col sm:flex-row justify-center gap-4">
                <?php
                if ($customers_page) {
                    echo '<a href="' . get_permalink($customers_page->ID) . '" class="px-8 py-4 bg-emerald-600 hover:bg-emerald-500 text-white rounded-xl font-bold transition shadow-xl shadow-emerald-900/20 text-lg">خرید اشتراک</a>';
                }
                if ($visitors_page) {
                    echo '<a href="' . get_permalink($visitors_page->ID) . '" class="px-8 py-4 bg-slate-800 hover:bg-slate-700 text-white border border-slate-700 rounded-xl font-bold transition text-lg">همکاری در فروش</a>';
                }
                ?>
            </div>
        </div>
    </section>
    <?php
} else {
    // Regular page content
    ?>
    <div class="max-w-7xl mx-auto px-4 py-20">
        <article class="bg-slate-900 p-8 rounded-2xl border border-slate-800">
            <h1 class="text-3xl md:text-4xl font-black text-white mb-6"><?php the_title(); ?></h1>
            <div class="text-slate-400 leading-relaxed">
                <?php the_content(); ?>
            </div>
        </article>
    </div>
    <?php
}
?>

<?php get_footer(); ?>
