<?php
add_action('after_setup_theme', function () {
    add_theme_support('title-tag');
    add_theme_support('automatic-feed-links');
    add_theme_support('post-thumbnails');
    add_theme_support('woocommerce');

    register_nav_menus([
        'main-menu' => __('منوی اصلی', 'pishro'),
    ]);
});

/**
 * Force WooCommerce default CSS to load (no theme/tailwind interference)
 */
add_action('wp_enqueue_scripts', function () {
    if (!class_exists('WooCommerce') || !class_exists('WC_Frontend_Scripts')) {
        return;
    }
    WC_Frontend_Scripts::load_scripts();
    foreach (WC_Frontend_Scripts::get_styles() as $handle => $style) {
        wp_enqueue_style($handle);
    }
}, 9999);

add_filter('woocommerce_enqueue_styles', function () {
    return class_exists('WC_Frontend_Scripts')
        ? WC_Frontend_Scripts::get_styles()
        : [];
}, 9999);
