<?php
/**
 * Template Name: محاسبه قیمت
 */
get_header(); 

// Load Chart.js for this page
echo '<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>';

// Read HTML file
$html_file = get_template_directory() . '/business_plan.html';
if (file_exists($html_file)) {
    $html_content = file_get_contents($html_file);
    
    // Extract body content
    preg_match('/<body[^>]*>(.*?)<\/body>/is', $html_content, $matches);
    
    if (isset($matches[1])) {
        $body_content = $matches[1];
        
        // Replace HTML links with WordPress permalinks
        $body_content = preg_replace('/href="index\.html"/', 'href="' . home_url('/') . '"', $body_content);
        $visitors_page = get_page_by_path('visitors');
        if ($visitors_page) {
            $body_content = preg_replace('/href="visitors\.html"/', 'href="' . get_permalink($visitors_page->ID) . '"', $body_content);
        }
        $business_plan_page = get_page_by_path('business-plan');
        if ($business_plan_page) {
            $body_content = preg_replace('/href="business_plan\.html"/', 'href="' . get_permalink($business_plan_page->ID) . '"', $body_content);
        }
        $customers_page = get_page_by_path('customers');
        if ($customers_page) {
            $body_content = preg_replace('/href="Proposal_For_Customers\.html"/', 'href="' . get_permalink($customers_page->ID) . '"', $body_content);
        }
        $bot_owners_page = get_page_by_path('bot-owners');
        if ($bot_owners_page) {
            $body_content = preg_replace('/href="Porposal_for_bot_owners\.html"/', 'href="' . get_permalink($bot_owners_page->ID) . '"', $body_content);
        }
        
        // Remove navigation and footer
        $body_content = preg_replace('/<nav[^>]*>.*?<\/nav>/is', '', $body_content);
        $body_content = preg_replace('/<footer[^>]*>.*?<\/footer>/is', '', $body_content);
        
        // Extract and add styles from head
        preg_match_all('/<style[^>]*>(.*?)<\/style>/is', $html_content, $style_matches);
        if (isset($style_matches[1])) {
            foreach ($style_matches[1] as $style) {
                echo '<style>' . $style . '</style>';
            }
        }
        
        // Output body content
        echo $body_content;
        
        // Extract and add all scripts
        preg_match_all('/<script[^>]*>(.*?)<\/script>/is', $html_content, $script_matches);
        if (isset($script_matches[0])) {
            foreach ($script_matches[0] as $script) {
                echo $script;
            }
        }
    }
}
?>

<?php get_footer(); ?>



